/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class FrameCounterButton
extends ImageButton
implements IElementWithTooltip {
    private final Screen screen;
    private final int secondaryFontColor;
    private final int mainFontColor;

    public FrameCounterButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(x, y, width, height, u, v, height, texture, 256, 256, button -> {}, (Component)Component.m_237119_());
        this.screen = screen;
        this.secondaryFontColor = Config.Client.getSecondaryFontColor();
        this.mainFontColor = Config.Client.getMainFontColor();
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float pPartialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, pPartialTick);
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        String text = camera.isEmpty() ? "-" : camera.getItem().getFilm(camera.getStack()).map(film -> {
            int exposedFrames = ((FilmRollItem)film.getItem()).getExposedFrames(film.getStack()).size();
            int totalFrames = ((FilmRollItem)film.getItem()).getMaxFrameCount(film.getStack());
            return exposedFrames + "/" + totalFrames;
        }).orElse("-");
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        int xPos = 15 + (27 - textWidth) / 2;
        font.m_92883_(poseStack, text, (float)(this.f_93620_ + xPos), (float)(this.f_93621_ + 8), this.secondaryFontColor);
        font.m_92883_(poseStack, text, (float)(this.f_93620_ + xPos), (float)(this.f_93621_ + 7), this.mainFontColor);
    }

    @Override
    public void m_7428_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        components.add(Component.m_237115_((String)"gui.exposure.viewfinder.film_frame_counter.tooltip"));
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        if (!camera.isEmpty() && camera.getItem().getFilm(camera.getStack()).isEmpty()) {
            components.add(Component.m_237115_((String)"gui.exposure.viewfinder.film_frame_counter.tooltip.no_film").m_130948_(Style.f_131099_.m_178520_(14508887)));
        }
        this.screen.m_169388_(poseStack, components, Optional.empty(), mouseX, mouseY);
    }
}

